IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_CREDITO_ICMS_ST_PIS_COFINS_DARE]'))
	DROP TRIGGER [dbo].[TRG_CREDITO_ICMS_ST_PIS_COFINS_DARE]
GO

CREATE TRIGGER [dbo].[TRG_CREDITO_ICMS_ST_PIS_COFINS_DARE]
ON [dbo].[EST_NF_ENT_DAR_IT]
AFTER INSERT
AS
BEGIN    
    DECLARE @Contagem INT;

    -- Contar o nmero de registros com base nas condies especificadas
    SELECT @Contagem = COUNT(*)
    FROM
        INSERTED D
        INNER JOIN GLB_NT_OP AS OP ON OP.CD_NT_OP = D.CD_NT_OP
    WHERE FLAG_DEDUZ_ICMS_ST_DARE_BASE_PIS_COFINS_SAIDA = 1;

    -- Verificar se existem registros para realizar a insero
    IF @Contagem > 0
    BEGIN

		UPDATE CREDITO
		SET VLR_ICMS_ST_DARE = COALESCE(D.VLR_ICMS_SUBS, 0)
		FROM INSERTED D
		INNER JOIN EST_NF_ENT_IT AS IT ON D.CD_NF = IT.CD_NF
										  AND D.CD_FILIAL = IT.CD_FILIAL
										  AND D.CD_EMP = IT.CD_EMP
										  AND D.CD_PROD = IT.CD_PROD
        INNER JOIN GLB_NT_OP AS OP ON OP.CD_NT_OP = D.CD_NT_OP
		INNER JOIN EST_NF_ENT_CREDITO_ICMS_ST_PIS_COFINS AS CREDITO ON IT.CD_EMP = CREDITO.CD_EMP
																	AND IT.CD_FILIAL = CREDITO.CD_FILIAL
																	AND IT.CD_NF = CREDITO.CD_NF
																	AND IT.CD_PROD = CREDITO.CD_PROD
		WHERE ((COALESCE(D.VLR_ICMS_SUBS, 0)) > 0)

        -- Inserir registros na tabela de destino se eles ainda no existirem
        INSERT INTO EST_NF_ENT_CREDITO_ICMS_ST_PIS_COFINS (
            CD_EMP,
            CD_FILIAL,
            CD_NF,
            CD_PROD,
			QT_IT,
            VLR_ICMS_ST_DARE,
            VLR_ICMS_EFETIVO,
            VLR_ICMS_SUBS,
            VLR_ICMS_RET,
            VLR_FECOP,
            VLR_FECOP_RET,
            VLR_FECOP_ST,
            SALDO_ZERADO
        )
        SELECT DISTINCT
            IT.CD_EMP, 
            IT.CD_FILIAL, 
            IT.CD_NF, 
            IT.CD_PROD,
			IT.QT_IT,
            CASE WHEN FLAG_DEDUZ_ICMS_ST_DARE_BASE_PIS_COFINS_SAIDA = 1 THEN COALESCE(D.VLR_ICMS_SUBS, 0) ELSE 0 END AS VLR_ICMS_ST_DARE, 
            0 AS VLR_ICMS_EFETIVO, 
            0 AS VLR_ICMS_SUBS, 
            0 AS VLR_ICMS_RET,         
            0 AS VLR_FECOP,  
            0 AS VLR_FECOP_RET,  
            0 AS VLR_FECOP_ST,  
            0 AS SALDO_ZERADO
        FROM
            INSERTED D
			INNER JOIN EST_NF_ENT_IT AS IT ON D.CD_NF = IT.CD_NF
											  AND D.CD_FILIAL = IT.CD_FILIAL
											  AND D.CD_EMP = IT.CD_EMP
											  AND D.CD_PROD = IT.CD_PROD
            INNER JOIN GLB_NT_OP AS OP ON OP.CD_NT_OP = D.CD_NT_OP
        WHERE
            (FLAG_DEDUZ_ICMS_ST_DARE_BASE_PIS_COFINS_SAIDA = 1)
            AND NOT EXISTS (
                SELECT 1 
                FROM EST_NF_ENT_CREDITO_ICMS_ST_PIS_COFINS AS CREDITO
                WHERE 
                    IT.CD_EMP = CREDITO.CD_EMP
                    AND IT.CD_FILIAL = CREDITO.CD_FILIAL
                    AND IT.CD_NF = CREDITO.CD_NF
                    AND IT.CD_PROD = CREDITO.CD_PROD
            )
			AND ((COALESCE(D.VLR_ICMS_SUBS, 0)) > 0)
			;
    END
    ELSE
    BEGIN
        PRINT 'Nenhum registro encontrado que atenda aos critrios.';
    END
END;